
%% *******************************************************************************************************************************
%% * ******************************************** ****************************************************************************** *
%% * *              LATEX TEMPLATE              * *               File       : Ph.D. Synopsis CLASS File                       * *
%% * *                   FOR                    * *               Created By : Dr Satvir Singh                                 * *
%% * *              PH.D. SYNOPSIS              * *               Email      : satvir15@gmail.com                              * *
%% * ******************************************** ****************************************************************************** *
%% *******************************************************************************************************************************

%% =====================================================================================================================================
%%                                                  PH.D. SYNOPSIS DOCUMENT CLASS FILE
%% =====================================================================================================================================

\NeedsTeXFormat{LaTeX2e}[1996/12/01]
\ProvidesClass{Thesis}
              [2007/22/02 v1.0
   LaTeX document class]
\def\baseclass{article}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{\baseclass}}
\def\@checkoptions#1#2{
  \edef\@curroptions{\@ptionlist{\@currname.\@currext}}
  \@tempswafalse
  \@tfor\@this:=#2\do{
    \@expandtwoargs\in@{,\@this,}{,\@curroptions,}
    \ifin@ \@tempswatrue \@break@tfor \fi}
  \let\@this\@empty
  \if@tempswa \else \PassOptionsToClass{#1}{\baseclass}\fi}
\@checkoptions{11pt}{{10pt}{11pt}{12pt}}
\PassOptionsToClass{a4paper}{\baseclass}
\ProcessOptions\relax
\LoadClass{\baseclass}
\newcommand\bhrule{\typeout{------------------------------------------------------------------------------}}

\newcommand\btypeout[1]{\bhrule\typeout{\space #1}\bhrule}
\def\monthyear{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space \number\year}
\usepackage{setspace}
\onehalfspacing
\setlength{\parindent}{0pt}
\setlength{\parskip}{2.0ex plus0.5ex minus0.2ex}
\usepackage{vmargin}
\setmarginsrb           { 1.3in}  % left margin
                        { 0.6in}  % top margin
                        { 1.0in}  % right margin
                        { 0.8in}  % bottom margin
                        {  20pt}  % head height
                        {0.25in}  % head sep
                        {   9pt}  % foot height
                        { 0.3in}  % foot sep
\raggedbottom
\setlength{\topskip}{1\topskip \@plus 5\p@}
\doublehyphendemerits=10000       % No consecutive line hyphens.
\brokenpenalty=10000              % No broken words across columns/pages.
\widowpenalty=9999                % Almost no widows at bottom of page.
\clubpenalty=9999                 % Almost no orphans at top of page.
\interfootnotelinepenalty=9999    % Almost never break footnotes.
\usepackage{fancyhdr}
%\lhead[\rm\thepage]{\fancyplain{}{\sl{\rightmark}}}
%\rhead[\fancyplain{}{\sl{\leftmark}}]{\rm\thepage}
\lfoot[\rm\thepage]{\fancyplain{}{\sl{\rightmark}}}
\rfoot[\fancyplain{}{\sl{\leftmark}}]{\rm\thepage}
\chead{}\cfoot{}%\rfoot{}\lfoot{}
%\pagestyle{fancy}
\renewcommand{\sectionmark}[1]{\markright{\thesection\ #1}}
\renewcommand{\subsectionmark}[1]{}
\def\cleardoublepage{\clearpage\if@twoside \ifodd\c@page\else
\hbox{}
\thispagestyle{empty}
\newpage
\if@twocolumn\hbox{}\newpage\fi\fi\fi}
\usepackage{amsmath,amsfonts,amssymb,amscd,amsthm,xspace}
\usepackage[centerlast,small,sc]{caption}
\setlength{\captionmargin}{20pt}
\newcommand{\fref}[1]{Figure~\ref{#1}}
\newcommand{\tref}[1]{Table~\ref{#1}}
\newcommand{\eref}[1]{Equation~\ref{#1}}
\newcommand{\sref}[1]{Section~\ref{#1}}
\newcommand{\aref}[1]{Appendix~\ref{#1}}
\renewcommand{\topfraction}{0.85}
\renewcommand{\bottomfraction}{.85}
\renewcommand{\textfraction}{0.1}
\renewcommand{\dbltopfraction}{.85}
\renewcommand{\floatpagefraction}{0.75}
\renewcommand{\dblfloatpagefraction}{.75}
\setcounter{topnumber}{9}
\setcounter{bottomnumber}{9}
\setcounter{totalnumber}{20}
\setcounter{dbltopnumber}{9}
\usepackage{graphicx}
\usepackage{epstopdf}
\usepackage[scriptsize]{subfigure}
\usepackage[Conny]{fncychapleo}
\usepackage{booktabs}
\usepackage{rotating}
\usepackage{listings}
\usepackage{lstpatch}
\lstset{captionpos=b,
        frame=tb,
        basicstyle=\scriptsize\ttfamily,
        showstringspaces=false,
        keepspaces=true}
\lstdefinestyle{matlab} {
        language=Matlab,
        keywordstyle=\color{blue},
        commentstyle=\color[rgb]{0.13,0.55,0.13}\em,
        stringstyle=\color[rgb]{0.7,0,0} }
\usepackage[comma, authoryear, sort&compress]{natbib}
\usepackage{verbatim}                               % Needed for the "comment" environment to make LaTeX comments
\usepackage{vector}                                 % Allows "\bvec{}" and "\buvec{}" for "blackboard" style bold vectors in maths
%\usepackage{makeidx}                                % To make Index at the end
%\hypersetup{urlcolor=blue, colorlinks=true}         % Colours hyperlinks in blue, but this can be distracting if there are many links.
\usepackage[pdfpagemode={UseOutlines},bookmarks=true,bookmarksopen=true,
   bookmarksopenlevel=0,bookmarksnumbered=true,hypertexnames=false,
   colorlinks,linkcolor={black},citecolor={blue},urlcolor={black},
   pdfstartview={FitH},unicode,breaklinks=true]{hyperref}
\pdfstringdefDisableCommands{
   \let\\\space}

%========================DON'T CHANGE THIS TEXT==================================
\newcommand*{\student}[1]{\def\studentname{#1}}
\newcommand*{\department}[1]{\def\deptname{#1}}
\newcommand*{\university}[2]{\def\univname{{\huge{\bf{#1}}\par}{\vskip -3mm \LARGE{#2}\par}}}
\newcommand*{\examiner}[1]{\def\examname{#1}}
\newcommand*{\college}[2]{\def\collname{{\Large{\bf{#1}}\par}{\LARGE{#2}\par}}}

%========================TITLE PAGE 1===========================================
\renewcommand\maketitle{
  \btypeout{Title Page}
  \hypersetup{pdftitle={\@title}}
  \hypersetup{pdfauthor=\studentname}
  \thispagestyle{empty}
  \begin{titlepage}
    \let\footnotesize\small
    \let\footnoterule\relax
    \let \footnote \thanks
    \begin{center}
        \setlength\fboxrule{1pt}\setlength\fboxsep{3mm}
        {\Huge \sc{Ph.D. Research Synopsis} \par}
        \vskip -3mm
        {\Huge {on} \par}
        {\LARGE \textbf{\@title} \par}
        \vskip 1mm
        {\Large {Submitted in partial fulfillment of the requirements for the degree of} \par}
        {\Large \textbf{Doctorate of Philosophy} \par}
        \vskip -3mm
        {\Large {in the} \par}
        \vskip -3mm
        {\Large \textbf{\deptname} \par}
        {\Large {By} \par}
        \vskip -3mm
        {\Large \textbf{\studentname} \par}
        \vskip -3mm
        {\Large {Under the Supervision of}\par}
        \vskip -3mm
        \begin{figure}[!h] \centering
            \includegraphics[height=30mm]{./FrontMatter/Guide2}
        \end{figure}
        \vskip -3mm
        \begin{figure}[!h] \centering
            \includegraphics[width=5cm]{./FrontMatter/PTULogo}
        \end{figure}
        \vskip -5mm
        \rule[1mm]{40em}{1pt}
        {\large \textbf{\univname} \par}
        \rule[10mm]{40em}{1pt}
        \vskip -7mm
        {\LARGE \sc{\@date} \par}
    \end{center}
    \par
    \@thanks
    \vfil\null
  \end{titlepage}
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
  \clearpage}
%=========================END - THESIS.CLS=======================================
